/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Text2DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class PointerLabel
extends Text2DDrawable {
    Point3D pointerEnd_;
    Line3D line_;
    Color pointerColor_;

    public PointerLabel(String label, Point3D pointerEnd, Point3D labelEnd, Color pointerColor, Color labelColor, Font labelFont) {
        super(label, labelEnd, 1, labelFont, labelColor);
        this.pointerEnd_ = pointerEnd;
        this.line_ = new Line3D(pointerEnd, labelEnd);
        this.pointerColor_ = pointerColor;
    }

    public PointerLabel(String label, Point3D pointerEnd, Point3D labelEnd) {
        this(label, pointerEnd, labelEnd, Color.black, Color.black, null);
    }

    public PointerLabel transform(Transform3D transform) {
        return new PointerLabel(this.getText(), transform.transform(this.pointerEnd_), transform.transform(this.getOrigin()), this.pointerColor_, this.getColor(), this.getFont());
    }

    private double abs(double a) {
        return a < 0.0 ? -a : a;
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        canvas.drawLine(this.line_, g, this.pointerColor_);
        Point3D p1 = canvas.project(this.pointerEnd_);
        Point3D p2 = canvas.project(this.getOrigin());
        if (p1.X() < p2.X()) {
            this.setJustification(2);
        } else {
            this.setJustification(1);
        }
        if (p1.Y() < p2.Y() && this.abs(p2.Y() - p1.Y()) > this.abs(p2.X() - p1.X())) {
            this.setJustification(0);
        } else if (p1.Y() > p2.Y() && this.abs(p2.Y() - p1.Y()) > this.abs(p2.X() - p1.X())) {
            this.setJustification(3);
        }
        super.drawOn(canvas, g);
    }
}

